package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;
import java.util.Calendar;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalDTOConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class ViewGoalController implements Serializable {
	private static final long serialVersionUID = 1L;

	private static Logger log = LogManager.getLogger(ViewGoalController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;

	@ManagedProperty("#{myGoalConverter}")
	private MyGoalConverter myGoalConverter;

	@ManagedProperty("#{myGoalDTOConverter}")
	private MyGoalDTOConverter myGoalDTOConverter;

	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;

	@ManagedProperty("#{param.goalId}")
	private Long goalId;

	private MyGoal goal;

	@PostConstruct
	public void init() {
		log.debug("@PostConstruct");

		log.debug("userProfileId=" + userProfile.getUserProfileId() + ", goalId=" + goalId);

		if (goalId != null && userProfile.getUserProfileId() != null) {
			MyGoalDTO dto = myGoalsWebServiceProxy.getMyGoalById(userProfile.getUserProfileId(), goalId);

			goal = myGoalConverter.convert(dto);
		}
	}

	public String delete() {
		log.debug("deleting userprofileId=" + goal.getUserProfileId() + ", goalId=" + goal.getGoalId() + ", goalName=" + goal.getGoalName());

		Response response = myGoalsWebServiceProxy.deleteMyGoal(goal.getUserProfileId(), goal.getGoalId());

		if (response.getStatus() == Status.NO_CONTENT.getStatusCode()) {
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "delete failed", "delete failed"));
			return null;
		}

		return "summary";
	}

	public String markComplete() {
		log.debug("markComplete userprofileId=" + goal.getUserProfileId() + ", goalId=" + goal.getGoalId() + ", goalName=" + goal.getGoalName());

		// check if all tasks completed
		if (!goal.getObstaclesWithUnfinishedTasks().isEmpty()) {
			String msg = "You have marked a Goal as completed, but you still have Tasks associated with this Goal that are not completed. Please mark all Tasks associated with this Goal as completed, and try again.";
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
			
			return null;
		}

		MyGoalDTO myGoalDTO = myGoalDTOConverter.convert(goal);

		Calendar completedDate = Calendar.getInstance();
		myGoalDTO.setCompletedDate(completedDate);

		log.debug("saving");

		MyGoalDTO resultDTO = null;

		try {
			resultDTO = myGoalsWebServiceProxy.saveMyGoal(userProfile.getUserProfileId(), myGoalDTO);

		} catch (Exception e) {
			log.debug(e);
		}

		log.debug("return from save");

		log.debug(resultDTO);

		if (resultDTO != null) {
			log.debug("Converting to MyGoal");

			goal = myGoalConverter.convert(resultDTO);

			log.debug(goal);

		} else {
			log.debug("error saving");
			// error
			FacesContext.getCurrentInstance().addMessage("", new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
			return null;
		}

		return "/views/completedgoals/summary";
	}

	public MyGoal getGoal() {
		return goal;
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalConverter(MyGoalConverter myGoalConverter) {
		this.myGoalConverter = myGoalConverter;
	}

	public void setMyGoalDTOConverter(MyGoalDTOConverter myGoalDTOConverter) {
		this.myGoalDTOConverter = myGoalDTOConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}
}
